/*/////////////////////////////////////////////////////////
// This code is based off of
// "Live Clock Lite" script - Version 1.0
// By Mark Plachetta (astroboy@zip.com.au)
//
// The original script displayed a clock.
// Mark Nielsen modified it to be a countdown timer
// for the lesson module in moodle.
//
//    Below is the code that is used to call this page.
//    echo "<script type=\"text/javascript\">\n";
//        echo "var starttime = ". $timer->starttime . ";\n";
//        echo "var servertime = ". time() . ";\n";
//        echo "var testlength = ". $lesson->maxtime * 60 .";\n";
//        echo "document.write('<script type=\"text/javascript\" src=\"liveclock_lite.js\"><\/script>');\n";
//        echo "window.onload = function () { show_clock(); }";
//    echo "</script>\n";
//
// Sarah Ashley and Wendi Turner have modified Mark Nielsen\s code to be a countup timer
// for the lesson module in Moodle. It shows how much time a user has spent in the lesson.
//
// Below is the code that is used to call the modified timer script page.
//    echo "<script type=\"text/javascript\">\n";
//    echo "var starttime = ". $thestarttime . ";\n";
//    echo "var servertime = ". time() . ";\n";
//    echo "var mintime = ". $lesson->completiontimespent .";\n";
//    echo "var savedtimespent = ". $timealreadyspent .";\n";
//    echo "var totaltime = ". $lessontimespent .";\n";
//    echo "document.write('<script type=\"text/javascript\" src=\"timespent.js\"><\/script>');\n";
//    echo "window.onload = function () { show_clock(); }";
//    echo "</script>\n";
//
//////////////////////////////////////////////////////////*/

    var stopclock = 0;
    var myclock = '';
    var logoutdiff = 0;
    var timeleft, hours, minutes, secs;
    var javatimeDate = new Date();
    var javatime = javatimeDate.getTime();
    javatime = Math.floor(javatime / 1000);

    if (typeof(clocksettings) != 'undefined') {
        if (clocksettings.starttime) {
            starttime = parseInt(clocksettings.starttime);
        }
        if (clocksettings.servertime) {
            servertime = parseInt(clocksettings.servertime);
        }
        if (clocksettings.mintime) {
            mintime = parseInt(clocksettings.mintime);
        }
    }

    difference = javatime - servertime;
    starttime = starttime + difference;

    function show_clock() {

        currentDate = new Date();
        current = currentDate.getTime();
        current = Math.floor(current / 1000);

        var mytime = '',
            myclock = document.getElementById("timestat");
        if (current >= starttime + mintime) {
            mytime += 'Time requirement' + \n + 'complete';
            stopclock = 1;
        } else {
            logoutdiff = savedtimespent - sessiontime;
       	    timespent = (current - starttime) + logoutdiff;
       	    //timespent -= pauseSeconds;
            if (timespent >= mintime) {
                mytime += 'Time requirement' + \n + 'complete';
                stopclock = 1;
            } else {
                hours = Math.floor(timespent / 3600);
                timespent = timespent - (hours * 3600);
                minutes = Math.floor(timespent / 60);
                secs = timespent - (minutes * 60);

                if (secs < 10) {
                    secs = "0" + secs;
                }
                if (minutes < 10) {
                    minutes = "0" + minutes;
                }
                mytime += hours + ":" + minutes + ":" + secs;
            }
        }

        myclock.innerHTML = mytime;

        if (stopclock == 0) {
           val = setTimeout(show_clock,1000);
        }
}
