<?php

/**
 * Ask question form
 */
defined('MOODLE_INTERNAL') || die;

require_once($CFG->libdir . '/formslib.php');
require_once($CFG->dirroot.'../config.php');
require_once('lib.php');

class askquestion_edit_form extends moodleform {   

    function definition() {
        global $USER, $CFG, $DB;

        $mform = $this->_form;
        $profile_field_category_id = get_config('local_askquestion', 'security_question_profile_field_category_id');

        if (isset($_SESSION['profileshortname'])) {
            $profileshortname = $_SESSION['profileshortname'];
        } else {
            $profile_fields = $DB->get_records('user_info_field', array('categoryid' => $profile_field_category_id));
            $extraprofilefields = array();

            if ($profile_fields) {
                foreach ($profile_fields as $profile_field) {
                    $extraprofilefields[] = $profile_field->shortname;
                }
                $rand_key = array_rand($extraprofilefields, 1);
                $profileshortname = $extraprofilefields[$rand_key];
                $_SESSION['profileshortname'] = $profileshortname;
            }
        }

        if (!$DB->record_exists('user_info_field', array('shortname' => $profileshortname))) {
            $displayquestion = false;
        } else {
            $profileinfo = $DB->get_record('user_info_field', array('shortname' => $profileshortname));
            $displayquestion = true;
            $securityquestiontext = $profileinfo->name;
        }

        if ($displayquestion) {
            $attributes = array('size' => '40');
			$URLattributes = array('size' => '100');
			$datarow = $DB->get_record('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id));
            $user_answer = $datarow->data;
            $profileanswers = array('movie' => $user_answer[0], 'book' => $user_answer[1], 'color' => $user_answer[2]);
            $mform->addElement('select', 'securityquestion', $securityquestiontext, $datarow);
			//$questionanswer = get_string_manager()->get_list_of_answers();
			
            //echo $user_answer;
        	//$default_answer[''] = 'Select your answer...';
        	//$questionanswers = array_merge($default_answer, $questionanswers);
        	//$mform->addElement('select', 'securityquestion', $user_answer);
			$mform->addRule('securityquestion', get_string('missingquestionanswer', 'local_askquestion'), 'required', null, 'client', false, false);
            $mform->setType('securityquestion', PARAM_TEXT);
        	/*if( !empty($CFG->country) ){
            	$mform->setDefault('country', $CFG->country);
        	}else{
            	$mform->setDefault('country', '');
        	}*/
			
            $this->add_action_buttons(false, 'Submit');
        } else {
            $mform->addElement('static', 'staticinfo', '', get_string('noquestiontext', 'local_askquestion'));
        }
    }

    //	Custom validation should be added here
    function validation($data, $files) {
        global $USER, $DB;
        $errors = array();
        $errors = parent::validation($data, $files);

        $profilefieldshortname = $_SESSION['profileshortname'];
        $profilefieldinfo = $DB->get_record('user_info_field', array('shortname' => $profilefieldshortname));

        if ($DB->record_exists('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id))) {
            $datarow = $DB->get_record('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id));

            if ($data['securityquestion'] !== $datarow->data) {
                if (isset($_SESSION['how_many_times_failed_in_answering'])) {
                    $_SESSION['how_many_times_failed_in_answering'] = $_SESSION['how_many_times_failed_in_answering'] + 1;
                } else {
                    $_SESSION['how_many_times_failed_in_answering'] = 1;
                }

                $max_attempt_allowed = get_config('local_askquestion', 'max_attempt_allowed_in_security_question');

                if ($_SESSION['how_many_times_failed_in_answering'] == $max_attempt_allowed) {
                    //invalidate user or suspend user
                    $errors['securityquestion'] = get_string('nomore_attempt', 'local_askquestion');
                    $logouturl = new moodle_url('/login/logout.php', array('sesskey' => sesskey()));
                    $userobj = new stdClass();
                    $userobj->id = $USER->id;
                    $userobj->suspended = 1;
                    $return = $DB->update_record('user', $userobj);
                    if ($return) {
                        send_account_suspend_email_to_user();
                    }
                    redirect($logouturl);
                } else if ($_SESSION['how_many_times_failed_in_answering'] == ($max_attempt_allowed - 1)) {
                    $remaning_attempt = $max_attempt_allowed - $_SESSION['how_many_times_failed_in_answering'];
                    $errors['securityquestion'] = get_string('errormsgfinal', 'local_askquestion', $remaning_attempt);
                } else if ($_SESSION['how_many_times_failed_in_answering'] < $max_attempt_allowed) {
                    $remaning_attempt = $max_attempt_allowed - $_SESSION['how_many_times_failed_in_answering'];
                    $errors['securityquestion'] = get_string('errormsg', 'local_askquestion', $remaning_attempt);
                }
            }
        } else {
            $errors['securityquestion'] = get_string('incomplete_profiledata', 'local_askquestion');
        }
        return $errors;
    }

}
