<?php

/**
 * Ask question form
 */
defined('MOODLE_INTERNAL') || die;

require_once($CFG->dirroot.'../config.php');
require_once($CFG->libdir . '/formslib.php');
require_once('lib.php');

class askquestion_edit_form extends moodleform {   

    function definition() {
        global $USER, $CFG, $DB;

        $mform = $this->_form;

        $profile_field_category_id = get_config('local_askquestion', 'security_question_profile_field_category_id');

        if (isset($_SESSION['profileshortname'])) {
            $profileshortname = $_SESSION['profileshortname'];
        } else {
            $profile_fields = $DB->get_records('user_info_field', array('categoryid' => $profile_field_category_id));
            $extraprofilefields = array();

            if ($profile_fields) {
                foreach ($profile_fields as $profile_field) {
                    $extraprofilefields[] = $profile_field->shortname;
                }
                $rand_key = array_rand($extraprofilefields, 1);
                $profileshortname = $extraprofilefields[$rand_key];
                $_SESSION['profileshortname'] = $profileshortname;
            }
        }

        if (!$DB->record_exists('user_info_field', array('shortname' => $profileshortname))) {
            $displayquestion = false;
        } else {
            $profileinfo = $DB->get_record('user_info_field', array('shortname' => $profileshortname));
            $displayquestion = true;
            $securityquestiontext = $profileinfo->name;
        }

        if ($displayquestion) {
            require_once($CFG->dirroot.'/user/profile/lib.php');
            require_once($CFG->dirroot.'/user/profile/field/'.$profileinfo->datatype.'/field.class.php');
            $newfield = 'profile_field_'.$profileinfo->datatype;
            $formfield = new $newfield($profileinfo->id, $USER->id);
            $formfield->edit_field($mform);
            $this->add_action_buttons(false, 'Submit');
        }
    }

    //	Custom validation should be added here
    function validation($data, $files) {
        global $USER, $DB;
        $errors = array();
        $errors = parent::validation($data, $files);

        $profilefieldshortname = $_SESSION['profileshortname'];
        $profilefieldinfo = $DB->get_record('user_info_field', array('shortname' => $profilefieldshortname));

        if ($DB->record_exists('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id))) {
            $datarow = $DB->get_record('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id));
				/* echo $profilefieldinfo->datatype; just checking to see if the type of question is truly being captured */
			if ($profilefieldinfo->datatype == 'menu') {
    			$options = explode("\n", $profilefieldinfo->param1);
    			$selecteddata = $data['profile_field_'.$profilefieldshortname];
    			//$submittedvalue = $options[$selectedindex];
    			$submittedvalue = $selecteddata;
    			/* echo $selectedindex; checking if the correct index for selected answer is being recorded */ 
			} else {
    			$submittedvalue = $data['profile_field_'.$profilefieldshortname];
			}
			
			if ($submittedvalue == $datarow->data) { 
				/* echo " // This answer is correct!"; just checking if it ever comes to this branch of the condition */ 
				//redirect($CFG->wwwroot . '/course/view.php?id=5');  
				//This automatically returns to the ask question index page and continues where it branched off to ask the question.
				//Specifically the code continues running from line 29 on askquestion/index.php
				//It will insert a record into the database that the user has been validated for answering correctly
				//after which it proceeds to take the user to the course home page
			} else {
				/* echo " // Wrong answer!"; just checking if it comes to this branch when user answers wrongly */
				
				if (isset($_SESSION['how_many_times_failed_in_answering'])) {
                    $_SESSION['how_many_times_failed_in_answering'] = $_SESSION['how_many_times_failed_in_answering'] + 1;
                } else {
                    $_SESSION['how_many_times_failed_in_answering'] = 1;
                }

                $max_attempt_allowed = get_config('local_askquestion', 'max_attempt_allowed_in_security_question');

                if ($_SESSION['how_many_times_failed_in_answering'] == $max_attempt_allowed) {
                    //invalidate user or suspend user
                    $errors['securityquestion'] = get_string('nomore_attempt', 'local_askquestion');
                    $logouturl = new moodle_url('/login/logout.php', array('sesskey' => sesskey()));
                    $userobj = new stdClass();
                    $userobj->id = $USER->id;
                    $userobj->suspended = 1;
                    $return = $DB->update_record('user', $userobj);
                     if ($return) {
                        send_account_suspend_email_to_user();
                        $to = $USER->email;
                        $fname = $USER->firstname;
                        $lname = $USER->lastname;
                        $sitename = $DB->get_field('course', 'fullname', array('id' => 1));
			$subject = "www.15DollarFloridaBDI.com: Your account has been blocked.";
			$txt = "Dear:\r\nYour account has been blocked on www.15DollarFloridaBDI.com because you did not answer your security questions correctly. \r\nPlease send me your phone number and I will call you and revalidate you, and get you back on track!";
			$headers = "From: CustomerCare@15DollarFloridaBDI.com";
			mail($to,$subject,$txt,$headers);
                    }
                    echo "<script type='text/javascript'>alert('Oh dear...your account has been blocked because you did not answer your security questions correctly. You will be logged out of the site after clicking the OK button below. Please send me your phone number via email to Admin@15DollarFloridaBDI.com, and I will call you and revalidate you, and get you back on track!')</script>";
                    redirect($logouturl);
                } else if ($_SESSION['how_many_times_failed_in_answering'] == ($max_attempt_allowed - 1)) {
                    $remaning_attempt = $max_attempt_allowed - $_SESSION['how_many_times_failed_in_answering'];
                    $errors['securityquestion'] = get_string('errormsgfinal', 'local_askquestion', $remaning_attempt);
                } else if ($_SESSION['how_many_times_failed_in_answering'] < $max_attempt_allowed) {
                    $remaning_attempt = $max_attempt_allowed - $_SESSION['how_many_times_failed_in_answering'];
                    $errors['securityquestion'] = get_string('errormsg', 'local_askquestion', $remaning_attempt);
                }
			}
        } else {
            $errors['securityquestion'] = get_string('incomplete_profiledata', 'local_askquestion');
        }
        return $errors;
    }

}