<?php

require_once('../../config.php');
require_once('edit_form.php');
require_once('lib.php');
$site = get_site();
global $DB, $USER, $PAGE;

require_login();

//if already respond to question redirect to site frontpage

$PAGE->set_context(context_system::instance());
$data = array();
$siteurl = new moodle_url('/index.php');
$url = new moodle_url('/course/view.php?id=5');  //this takes user back to course page instead of main site after answering questions
$PAGE->set_url('/local/askquestion/index.php');

if (isloggedin() && !is_siteadmin($USER->id) && !isguestuser($USER->id)) {
    //if already respond to question redirect to site frontpage
    if ($DB->record_exists('local_askquestion', array('userid' => $USER->id, 'validated' => 1))) {
       redirect($siteurl);
   }

    $editform = new askquestion_edit_form(NULL);

    if ($fromform = $editform->get_data()) {
        $fromdata = (array) $fromform;
        if (!$errors = $editform->validation($fromdata, null)) {
            // insert a vlaue in the table so that user will not asked a question again if he or she come on this page
            $record = new stdClass();
            $record->userid = $USER->id;
            $record->validated = 1;
            $return = $DB->insert_record('local_askquestion', $record, true);
//print_r($record);
			redirect($url);
        } else {
            $max_attempt_allowed = get_config('local_askquestion', 'max_attempt_allowed_in_security_question');
            if ($_SESSION['how_many_times_failed_in_answering'] >= $max_attempt_allowed) {
                $logouturl = new moodle_url('/login/logout.php', array('sesskey' => sesskey()));
                $userobj = new stdClass();
                $userobj->id = $USER->id;
                $userobj->suspended = 1;
                $return = $DB->update_record('user', $obj);
                send_account_suspend_email_to_user();
                echo $errors;
                redirect($logouturl);
            }
        }
    } else {
        $PAGE->set_pagelayout('base');
        $PAGE->set_url('/local/askquestion/index.php');
        $PAGE->set_context(context_system::instance());

        $heading = get_string('security_ques', 'local_askquestion');
        $title = "$site->shortname: " . $heading;

        $PAGE->navbar->add($heading);
        $PAGE->set_title($title);
        $PAGE->set_heading($heading);

        echo $OUTPUT->header();
        echo $OUTPUT->heading($heading);
        $editform->display();
        echo $OUTPUT->footer();
    }
}
?>